#ifndef RFDECODE_H
#define RFDECODE_H

enum Remote_Control_Status{	
	R_INIT = 			0, 
	R_OFF = 			1,
	R_1_SPEED = 		2, 
	R_2_SPEED = 		3,
	R_3_SPEED = 		4,
	R_4_SPEED = 		5,
	R_SMART = 			6,
	R_3H = 				7,
	R_6H = 				8,
	R_9H = 				9
};
extern xdata 	uint8 	RF_Channel;
// <<< Use Configuration Wizard in Context Menu >>>
// <e> RF Enable/Disable
#define RF_Control 1
#if (RF_Control == 1)||(IR_Control == 1)

void IRLearning_mode(void);
extern void IRDecode_Init (void);


extern uint8 			IR_Byte[5];
extern xdata	uint8 	RF_Address[3];
extern uint8	test_ir;

	// <h> Set IR_DEC_CTRL
		// <o.6> IRIN_SEL <0=> IR decode data input from PIN CH3 <1=> IR decode data input from PIN CH7 
			#define IR_DEC_CTRL_REGS 0xC0
	// </h>

	// <h> Set IR_DEC_SET
		// <o.0..2> CLK_DIV_SEL <0=> 24MHz <1=> 16MHz <2=> 8MHz <3=> 6MHz <4=> 3MHz <5=> 2MHz 
		// <o.3..4> DIN_DB_SEL <0=> 0ns <1=> 250ns <2=> 500ns <3=> 1000ns
		// <o.5> DIN_TYP <0=> Data Type1 <1=> Data Type2
		// <i> Data Type1 = Falling to Rising edge: Duty > 50% -> Din = 0; Duty < 50% -> Din = 1
		// <i> Data Type2 = Falling to Rising edge: Duty > 50% -> Din = 1; Duty < 50% -> Din = 0
		// <o.6> DOUT_REV <0=> First input data is LSB <1=> First input data is MSB 
		// <o.7> HEADER_EN <0=> No HEADER <1=> With HEADER
			#define IR_DEC_SET_REGS 		0x95
	// </h>
	
	//<h> Remote control code set
		//<h> Head code set
		
			// <o> 	Head code 1 TIME set (unit : us)
					#define IR_HEADER1_TIME 		5000
					
			// <o> 	Head code 2 TIME set (unit : us)
					#define IR_HEADER2_TIME 		7800
		//</h>
		
		//<e> Remote control decoding to UR Enable
			#define Remote_control_decoding_Enable 	0
		// </e>
		
		// <e> No Remote control Learn mode
			#define No_Remote_control_Learn_mode 0
			#if (No_Remote_control_Learn_mode == 1)
				//<h> RF address code set
					//<o> Set RF address1<0x00-0xFF>
						#define IR_ADDRESS_1			0x7F
						
					//<o> Set RF address2<0x00-0xFF>
						#define IR_ADDRESS_2			0xD4
					
					//<o> Set RF address3<0x00-0xFF>
						#define IR_ADDRESS_3			0x0F
				//</h>
			#endif
		// </e> 
		
		#if (No_Remote_control_Learn_mode == 0)
			//<o> Set learn time(unit : sec)<0-20>
				#define Learning_TIME					(5)
			//<o> Judge the times of successful learning(unit : 10 times)<0-20>
				#define Successful_Learning_TIMES		(1)*10
		#endif
		
		// <h> 	RF data code set
			// <h>  Button speed 1
				// <o> 	Data code 1<0x00-0xFF>
					#define RF_DATA_1_1				0x10
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_1_2				0x3E
			// </h>

			// <h>  Button speed 2
				// <o> 	Data code 1<0x00-0xFF>
					#define RF_DATA_2_1				0x90
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_2_2				0x36
			// </h>

			// <h>  Button speed 3
				// <o> 	Data code 1<0x00-0xFF>
					#define RF_DATA_3_1				0xA0
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_3_2				0x35
			// </h>

			// <h>  Button speed 4
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_4_1				0x30
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_4_2				0x3C
			// </h>

			// <h>  Button off
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_off_1			0xB0
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_off_2			0x34
			// </h>
			
			// <h>  Button SMART
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_smart_1			0xC0
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_smart_2			0x33
			// </h>
			
			// <h>  Button Timer 3H
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_3H_1			0x40
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_3H_2			0x3B
			// </h>
			
			// <h>  Button Timer 6H
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_6H_1			0x80
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_6H_2			0x37
			// </h>
			
			// <h>  Button Timer 9H
				// <o> 	Data code 1<0x00-0xFF>	
					#define RF_DATA_9H_1			0x20
					
				// <o> Data code 2<0x00-0xFF>
					#define RF_DATA_9H_2			0x3D
			// </h>
		// </h>
		
		// <h> 	RF Speed set
			// <o> 	Set RF Button SPEED1 speed
				#define IR_SPEED_1					100
				
			// <o> Set RF Button SPEED2 speed
				#define IR_SPEED_2					150
				
			// <o> Set RF Button SPEED3 speed
				#define IR_SPEED_3					200

			// <o> Set RF Button SPEED4 speed
				#define IR_SPEED_4					330
			
			// <e> Observe Speed_UI parameters Enable
				#define	 Observe_Speed_UI		0
			// </e>
			
			// <o> Set RF Button1_SPEED_UI<0-32767>
				#define IR_SPEED_UI_1				350
				
			// <o> Set RF Button2_SPEED_UI<0-32767>
				#define IR_SPEED_UI_2				500
				
			// <o> Set RF Button3_SPEED_UI<0-32767>
				#define IR_SPEED_UI_3				900
				
			// <o> Set RF Button4_SPEED_UI<0-32767>
				#define IR_SPEED_UI_4				1200
		// </h>

		// <h> 	IR/RF Current set
			// <o> 	Set RF Button Current1 (unit : mA)<300-4000>
				#define IR_Current_1				(float)500/1000
				#define IR_Current_1_VALUE 			(int16)((float) IR_Current_1 * I_AMPLIFIER) // unit : A * Gain
				
			// <o> Set RF Button Current2 (unit : mA)<300-4000>
				#define IR_Current_2				(float)1000/1000
				#define IR_Current_2_VALUE 			(int16)((float) IR_Current_2 * I_AMPLIFIER) // unit : A * Gain
				
			// <o> Set RF Button Current3 (unit : mA)<300-4000>
				#define IR_Current_3				(float)1600/1000
				#define IR_Current_3_VALUE 			(int16)((float) IR_Current_3 * I_AMPLIFIER) // unit : A * Gain

			// <o> Set RF Button Current4 (unit : mA)<300-4000>
				#define IR_Current_4				(float)1850/1000
				#define IR_Current_4_VALUE 			(int16)((float) IR_Current_4 * I_AMPLIFIER) // unit : A * Gain
		// </h>
		
		#if (Remote_control_decoding_Enable == 1) && (Observe_Speed_UI == 1)
			#error Wrong setting Remote_control_decoding_Enable and Observe_Speed_UI !!!!
		#endif
		
	// </h>
#endif
// <<< end of configuration section >>>
#endif